
`Effect data
type Lighting_EffectData
   InUse as integer
   Effect as integer
endtype

`--------------
` Add Effect
`--------------
function AddEffect(iEffect as integer)
   tEffect=-1
   for e=0 to Lighting_EffectsCount
      if Lighting_Effects[e].InUse=0 
         tEffect=e
         exit
      endif
   next e
   if tEffect=-1
      inc Lighting_EffectsCount
      Lighting_Effects.length=Lighting_Effects.length+1
      tEffect=Lighting_EffectsCount
   endif
   Lighting_Effects[tEffect].InUse=1
   Lighting_Effects[tEffect].Effect=iEffect
   Set_Vector4(1,((Lighting_Fog.x/255)^2.2),((Lighting_Fog.y/255)^2.2),((Lighting_Fog.z/255)^2.2),Lighting_Fog.w)
   SetEffectConstantVector(Lighting_Effects[tEffect].Effect,"FogColor",1)
   Set_Vector4(1,((Lighting_AmbientColor.x/255)^2.2),((Lighting_AmbientColor.y/255)^2.2),((Lighting_AmbientColor.z/255)^2.2),0)
   SetEffectConstantVector(Lighting_Effects[tEffect].Effect,"AmbientColor",1)
   Set_Vector4(1,Lighting_LightDirection.x,Lighting_LightDirection.y,Lighting_LightDirection.z,0)
   SetEffectConstantVector(Lighting_Effects[tEffect].Effect,"LightDirection",1)
   Set_Vector4(1,((Lighting_LightDirectionColor.x/255)^2.2),((Lighting_LightDirectionColor.y/255)^2.2),((Lighting_LightDirectionColor.z/255)^2.2),0)
   SetEffectConstantVector(Lighting_Effects[tEffect].Effect,"LightDirectionColor",1)
   Set_Vector4(1,Lighting_ShadowMapDirSize,1.0/Lighting_ShadowMapDirSize,0,0)
   SetEffectConstantVector(Lighting_Effects[tEffect].Effect,"ShadowsSize",1)
endfunction tEffect

`-------------- 
` Remove Effect
`--------------
function RemoveEffect(iEffect as integer)
   if Lighting_Effects[iEffect].InUse=1
      Lighting_Effects[iEffect].InUse=0
   endif
endfunction
